from subprocess import PIPE, run
import json, sys, time
from dnsimple import DNSimple, DNSimpleException
from tld import get_tld

DNSIMPLE_API_KEY='e3cP5vvYF7AHk2qqCC4VYqaMHERmzr8w'
dns = DNSimple(api_token=DNSIMPLE_API_KEY)

try:
  nodeName = sys.argv[1]
except:
  print("Usage: python3 migrate.py <nodeName>")
  sys.exit(1)

print("Getting sites on", nodeName)

cmd = 'node deploy/app-cli/app-cli.js site list --nodename='+nodeName

def out(command):
  result = run(command, stdout=PIPE, stderr=PIPE, universal_newlines=True, shell=True)
  return result.stdout

res = out(cmd)
sites = json.loads(res)
manualDns = []

for site in sites[0:10]:

  hostMappings = list(map(lambda hm: hm['sourceHostname'], site['hostMappings']))
  hostMappings = list(filter(lambda d: 'widepath.site' not in d and 'widepath.app' not in d, hostMappings))
  domains = map(lambda d: get_tld(d, fix_protocol=True, as_object=True).fld, hostMappings)
  domains = set(domains)
  domains = list(domains)

  print("\n"+site['siteStub'])
  print(hostMappings)

  # add the site
  cmd = 'node deploy/app-cli/app-cli.js cdn add ' + site['siteStub']
  print(cmd)

  # add domains
  cmd = 'node deploy/app-cli/app-cli.js cdn add-domains ' + site['siteStub']
  print(cmd)

  # get subdomains
  print("HOSTMAPPINGS", hostMappings)
  print("DOMAINS", domains)

  def replaceAll(hostname, domains):
    for d in domains:
      hostname = hostname.replace(d, '')
      if len(hostname) > 0 and (hostname[-1] == '.'): hostname = hostname[0:-1]
    return hostname
  subs = map(lambda h: replaceAll(h, domains), hostMappings)
  subs = filter(lambda h: h, subs)
  print("Subs", list(subs))

  # dns flip
  print("DNSFLIP...", domains)
  for domain in domains:
    print("FLIP", domain)
    try:
      d = dns.domain(domain)
    except DNSimpleException as ex:
      print("MANUAL DNS", domain)
      manualDns.append(domain)
    print(d)

  # request cert
  cmd = 'node deploy/app-cli/app-cli.js cdn cert-request ' + site['siteStub']
  print(cmd)

  time.sleep(2)

print("Done")
print("Manual DNS", manualDns)
