/*!
* easyPieChart
* Lightweight plugin to render simple, animated and retina optimized pie charts
*
* @author Robert Fleischmann <rendro87@gmail.com> (http://robert-fleischmann.de)
* @version 2.1.5
*
* Modified to adapt the latest jQuery version (v3 above) included on WordPress 5.6:
* - (2020-12-15) - jQuery isFunction method is deprecated.
*/
(function(root,factory){if(typeof exports==='object'){module.exports=factory(require('jquery'))}else if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else{factory(root.jQuery)}}(this,function($){var CanvasRenderer=function(el,options){var cachedBackground;var canvas=document.createElement('canvas');el.appendChild(canvas);if(typeof(G_vmlCanvasManager)!=='undefined'){G_vmlCanvasManager.initElement(canvas)}
var ctx=canvas.getContext('2d');canvas.width=canvas.height=options.size;var scaleBy=1;if(window.devicePixelRatio>1){scaleBy=window.devicePixelRatio;canvas.style.width=canvas.style.height=[options.size,'px'].join('');canvas.width=canvas.height=options.size*scaleBy;ctx.scale(scaleBy,scaleBy)}
ctx.translate(options.size/2,options.size/2);ctx.rotate((-1/2+options.rotate/180)*Math.PI);var radius=(options.size-options.lineWidth)/2;if(options.scaleColor&&options.scaleLength){radius-=options.scaleLength+2}
Date.now=Date.now||function(){return+(new Date())};var drawCircle=function(color,lineWidth,percent,alpha){percent=Math.min(Math.max(-1,percent||0),1);var isNegative=percent<=0?!0:!1;ctx.beginPath();ctx.arc(0,0,radius,0,Math.PI*2*percent,isNegative);ctx.strokeStyle=color;ctx.globalAlpha=alpha;ctx.lineWidth=lineWidth;ctx.stroke()};var drawScale=function(){var offset;var length;ctx.lineWidth=1;ctx.fillStyle=options.scaleColor;ctx.save();for(var i=24;i>0;--i){if(i%6===0){length=options.scaleLength;offset=0}else{length=options.scaleLength*0.6;offset=options.scaleLength-length}
ctx.fillRect(-options.size/2+offset,0,length,1);ctx.rotate(Math.PI/12)}
ctx.restore()};var reqAnimationFrame=(function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||function(callback){window.setTimeout(callback,1000/60)}}());var drawBackground=function(){if(options.scaleColor)drawScale();if(options.trackColor)drawCircle(options.trackColor,options.lineWidth,1,options.trackAlpha)};this.getCanvas=function(){return canvas};this.getCtx=function(){return ctx};this.clear=function(){ctx.clearRect(options.size/-2,options.size/-2,options.size,options.size)};this.draw=function(percent){if(!!options.scaleColor||!!options.trackColor){if(ctx.getImageData&&ctx.putImageData){if(!cachedBackground){drawBackground();cachedBackground=ctx.getImageData(0,0,options.size*scaleBy,options.size*scaleBy)}else{ctx.putImageData(cachedBackground,0,0)}}else{this.clear();drawBackground()}}else{this.clear()}
ctx.lineCap=options.lineCap;var color;if(typeof(options.barColor)==='function'){color=options.barColor(percent)}else{color=options.barColor}
drawCircle(color,options.lineWidth,percent/100,options.barAlpha)}.bind(this);this.animate=function(from,to){var startTime=Date.now();options.onStart(from,to);var animation=function(){var process=Math.min(Date.now()-startTime,options.animate.duration);var currentValue=options.easing(this,process,from,to-from,options.animate.duration);this.draw(currentValue);options.onStep(from,to,currentValue);if(process>=options.animate.duration){options.onStop(from,to)}else{reqAnimationFrame(animation)}}.bind(this);reqAnimationFrame(animation)}.bind(this)};var EasyPieChart=function(el,opts){var defaultOptions={barColor:'#ef1e25',barAlpha:1.0,trackColor:'#f9f9f9',trackAlpha:1.0,scaleColor:'#dfe0e0',scaleLength:5,lineCap:'round',lineWidth:3,size:110,rotate:0,render:!0,animate:{duration:1000,enabled:!0},easing:function(x,t,b,c,d){t=t/(d/2);if(t<1){return c/2*t*t+b}
return-c/2*((--t)*(t-2)-1)+b},onStart:function(from,to){return},onStep:function(from,to,currentValue){return},onStop:function(from,to){return}};if(typeof(CanvasRenderer)!=='undefined'){defaultOptions.renderer=CanvasRenderer}else if(typeof(SVGRenderer)!=='undefined'){defaultOptions.renderer=SVGRenderer}else{throw new Error('Please load either the SVG- or the CanvasRenderer')}
var options={};var currentValue=0;var init=function(){this.el=el;this.options=options;for(var i in defaultOptions){if(defaultOptions.hasOwnProperty(i)){options[i]=opts&&typeof(opts[i])!=='undefined'?opts[i]:defaultOptions[i];if(typeof(options[i])==='function'){options[i]=options[i].bind(this)}}}
if(typeof(options.easing)==='string'&&typeof(jQuery)!=='undefined'&&'function'===typeof jQuery.easing[options.easing]){options.easing=jQuery.easing[options.easing]}else{options.easing=defaultOptions.easing}
if(typeof(options.animate)==='number'){options.animate={duration:options.animate,enabled:!0}}
if(typeof(options.animate)==='boolean'&&!options.animate){options.animate={duration:1000,enabled:options.animate}}
this.renderer=new options.renderer(el,options);this.renderer.draw(currentValue);if(el.dataset&&el.dataset.percent){this.update(parseFloat(el.dataset.percent))}else if(el.getAttribute&&el.getAttribute('data-percent')){this.update(parseFloat(el.getAttribute('data-percent')))}}.bind(this);this.update=function(newValue){newValue=parseFloat(newValue);if(options.animate.enabled){this.renderer.animate(currentValue,newValue)}else{this.renderer.draw(newValue)}
currentValue=newValue;return this}.bind(this);this.disableAnimation=function(){options.animate.enabled=!1;return this};this.enableAnimation=function(){options.animate.enabled=!0;return this};init()};$.fn.easyPieChart=function(options){return this.each(function(){var instanceOptions;if(!$.data(this,'easyPieChart')){instanceOptions=$.extend({},options,$(this).data());$.data(this,'easyPieChart',new EasyPieChart(this,instanceOptions))}})}}));
/*! ET et_shortcodes_frontend.js */
(function($){$.fn.et_shortcodes_switcher=function(options){var defaults={slides:'>div',activeClass:'active',linksNav:'',findParent:!0,lengthElement:'li',useArrows:!1,arrowLeft:'a#prev-arrow',arrowRight:'a#next-arrow',auto:!1,autoSpeed:5000,slidePadding:'',pauseOnHover:!0,fx:'fade',sliderType:''};var options=$.extend(defaults,options);return this.each(function(){var slidesContainer=jQuery(this).parent().css('position','relative'),$slides=jQuery(this).css({'overflow':'hidden','position':'relative'}),$slides_wrapper_box=slidesContainer.find('.et-tabs-content-wrapper'),$slides_wrapper=$slides_wrapper_box.parent(),$slide=$slides.find('.et-tabs-content-wrapper'+options.slides),slidesNum=$slide.length,zIndex=slidesNum,currentPosition=1,slideHeight=0,$activeSlide,$nextSlide,slides_wrapper_width=$slides_wrapper.width(),$et_shortcodes_mobile_nav,$et_shortcodes_mobile_controls;if(options.fx==='slide'){$slides_wrapper_box.width(((slidesNum+2)*200)+'%');$slide.css({'width':slides_wrapper_width+'px','visibility':'visible',});$slides_wrapper_box.append($slide.first().clone().removeClass().addClass('et_slidecontent_cloned'));$slides_wrapper_box.prepend($slide.last().clone().removeClass().addClass('et_slidecontent_cloned'));$slides_wrapper_box.css('left',-slides_wrapper_width+'px')}
$slide.first().css({'display':'block'}).addClass('et_shortcode_slide_active');if(''!==options.slidePadding){var slidePaddingOption='number'===typeof options.slidePadding?options.slidePadding+'px':options.slidePadding;$slide.css('padding',slidePaddingOption)}
if(options.linksNav!=''){var linkSwitcher=jQuery(options.linksNav);var linkSwitcherTab='';if(options.findParent)linkSwitcherTab=linkSwitcher.parent();else linkSwitcherTab=linkSwitcher;if(!linkSwitcherTab.filter('.active').length)linkSwitcherTab.first().addClass('active');linkSwitcher.on('click',function(){var targetElement,orderNum;if(options.findParent)targetElement=jQuery(this).parent();else targetElement=jQuery(this);orderNum=targetElement.prevAll(options.lengthElement).length+1;if(orderNum>currentPosition)gotoSlide(orderNum,1);else gotoSlide(orderNum,-1);return!1})}
if(options.useArrows){var $right_arrow=jQuery(options.arrowRight),$left_arrow=jQuery(options.arrowLeft);$right_arrow.on('click',function(){et_shortcodes_go_to_next_slide();return!1});$left_arrow.on('click',function(){et_shortcodes_go_to_previous_slide();return!1})}
function changeTab(){if(linkSwitcherTab!=''){linkSwitcherTab.siblings().removeClass('active');linkSwitcherTab.eq(currentPosition-1).addClass('active')}}
function gotoSlide(slideNumber,dir){if($slide.filter(':animated').length)return;$activeSlide=$slide.parent().find('.et_slidecontent').eq(currentPosition-1);if(currentPosition===slideNumber)return;$activeSlide.removeClass('et_shortcode_slide_active');$nextSlide=$slide.parent().find('.et_slidecontent').eq(slideNumber-1).addClass('et_shortcode_slide_active');if((currentPosition>slideNumber||currentPosition===1)&&(dir===-1)){if(options.fx==='slide')slideBack(500);if(options.fx==='fade')slideFade(500)}else{if(options.fx==='slide')slideForward(500);if(options.fx==='fade')slideFade(500)}
currentPosition=$nextSlide.prevAll('.et_slidecontent').length+1;if(options.linksNav!='')changeTab();if(options.sliderType==='images'||options.sliderType==='simple'){$et_shortcodes_mobile_controls.find('li').removeClass('et_shortcodes_active_control');$et_shortcodes_mobile_controls.find('li').eq(currentPosition-1).addClass('et_shortcodes_active_control')}
return!1}
if(options.auto){auto_rotate();var pauseSlider=!1}
if(options.pauseOnHover){slidesContainer.on('mouseenter',function(){pauseSlider=!0}).on('mouseleave',function(){pauseSlider=!1})}
function auto_rotate(){interval_shortcodes=setInterval(function(){if(!pauseSlider){if(currentPosition===slidesNum)
gotoSlide(1,1);else gotoSlide(currentPosition+1,1);if(options.linksNav!='')changeTab()}},options.autoSpeed)}
function slideFade(speed){$activeSlide.css({'display':'none','opacity':'0'});$nextSlide.css({'opacity':'0','display':'block'}).animate({opacity:1},700)}
function slideForward(speed){var next_slide_order=$nextSlide.prevAll('.et_slidecontent').length+1,go_to_first_slide=!1;if($activeSlide.next('.et_slidecontent_cloned').length){next_slide_order=$activeSlide.prevAll().length+1;go_to_first_slide=!0}
$slides_wrapper_box.animate({left:-($slides_wrapper.width()*next_slide_order)},500,function(){if(go_to_first_slide){$slides_wrapper_box.css('left',-$slides_wrapper.width()+'px')}})}
function slideBack(speed){var next_slide_order=$nextSlide.prevAll('.et_slidecontent').length+1,go_to_last_slide=!1;if($activeSlide.prev('.et_slidecontent_cloned').length){next_slide_order=0;go_to_last_slide=!0}
$slides_wrapper_box.animate({left:-($slides_wrapper.width()*next_slide_order)},500,function(){if(go_to_last_slide){$slides_wrapper_box.css('left',-($slides_wrapper.width()*slidesNum)+'px')}})}
if(options.fx==='slide'){$(window).on('resize',function(){$slides_wrapper_box.find('>div').css({'width':$slides_wrapper.width()+'px'});$slides_wrapper_box.css('left',-($slides_wrapper.width()*currentPosition)+'px')})}
et_generate_mobile_nav();function et_generate_mobile_nav(){var et_shortcodes_slides_num=slidesContainer.find('.et_slidecontent').length,et_shortcodes_controllers_html='';if(et_shortcodes_slides_num>1&&(options.sliderType==='images'||options.sliderType==='simple')){slidesContainer.append('<div class="et_shortcodes_controller_nav">'+'<ul class="et_shortcodes_controls"></ul>'+'<ul class="et_shortcodes_controls_arrows"><li><a href="#" class="et_sc_nav_next">'+et_shortcodes_strings.next+'<span></span></a></li><li><a href="#" class="et_sc_nav_prev">'+et_shortcodes_strings.previous+'<span></span></a></li></ul>'+'</div>');$et_shortcodes_mobile_controls=slidesContainer.find('.et_shortcodes_controls');for(var i=0;i<et_shortcodes_slides_num;i++){et_shortcodes_controllers_html+='<li><a href="#"></a></li>'}
$et_shortcodes_mobile_controls.prepend(et_shortcodes_controllers_html);$et_shortcodes_mobile_controls.find('li').first().addClass('et_shortcodes_active_control');$et_shortcodes_mobile_controls.find('a').on('click',function(){var $this_control=$(this),$this_control_li=$this_control.parent('li'),this_order=$this_control_li.prevAll().length+1;if(this_order==currentPosition)return!1;if(this_order>currentPosition)gotoSlide(this_order,1);else gotoSlide(this_order,-1);return!1});$et_shortcodes_mobile_nav=slidesContainer.find('.et_shortcodes_controls_arrows');$et_shortcodes_mobile_nav.find('a').on('click',function(){var $this_link=jQuery(this),et_active_slide_order;if($this_link.hasClass('et_sc_nav_next'))
et_shortcodes_go_to_next_slide();if($this_link.hasClass('et_sc_nav_prev'))
et_shortcodes_go_to_previous_slide();$et_shortcodes_mobile_controls.find('li').removeClass('et_shortcodes_active_control');et_active_slide_order=currentPosition-1;$et_shortcodes_mobile_controls.find('li').eq(et_active_slide_order).addClass('et_shortcodes_active_control');return!1})}else if(options.sliderType!=='images'&&options.sliderType!=='simple'){slidesContainer.prepend('<ul class="et_shortcodes_mobile_nav"><li><a href="#" class="et_sc_nav_next">'+et_shortcodes_strings.next+'<span></span></a></li><li><a href="#" class="et_sc_nav_prev">'+et_shortcodes_strings.previous+'<span></span></a></li></ul>');$et_shortcodes_mobile_nav=slidesContainer.find('.et_shortcodes_mobile_nav');$et_shortcodes_mobile_nav.find('a').on('click',function(){var $this_link=jQuery(this);if($this_link.hasClass('et_sc_nav_next'))
et_shortcodes_go_to_next_slide();if($this_link.hasClass('et_sc_nav_prev'))
et_shortcodes_go_to_previous_slide();return!1})}}
function et_shortcodes_go_to_next_slide(){if(currentPosition===slidesNum)
gotoSlide(1,1);else gotoSlide(currentPosition+1,1);if(options.linksNav!='')changeTab()}
function et_shortcodes_go_to_previous_slide(){if(currentPosition===1)
gotoSlide(slidesNum,-1);else gotoSlide(currentPosition-1,-1);if(options.linksNav!='')changeTab()}})}
window.et_shortcodes_init=function($container){var $processed_container=typeof $container!=='undefined'?$container:$('body');var $et_pricing_table_button=$processed_container.find('.pricing-table a.icon-button');$et_tooltip=$processed_container.find('.et-tooltip');$et_tooltip.on('mouseover mouseout',function(event){if(event.type=='mouseover'){$(this).find('.et-tooltip-box').stop(!0,!0).animate({opacity:'show',bottom:'25px'},300)}else{$(this).find('.et-tooltip-box').delay(200).animate({opacity:'hide',bottom:'35px'},300)}});$et_learn_more=$processed_container.find('.et-learn-more .heading-more');$et_learn_more.on('click',function(){if($(this).hasClass('open')){$(this).removeClass('open')}else{$(this).addClass('open')}
$(this).parent('.et-learn-more').find('.learn-more-content').animate({opacity:'toggle',height:'toggle'},300)});$processed_container.find('.et-learn-more').not('.et-open').find('.learn-more-content').css({'visibility':'visible','display':'none'});$et_pricing_table_button.each(function(){var $this_button=$(this),this_button_width=$this_button.width(),this_button_innerwidth=$this_button.innerWidth();$this_button.css({width:this_button_width+'px','marginLeft':'-'+(this_button_innerwidth/2)+'px','visibility':'visible',})});var $et_shortcodes_tabs=$processed_container.find('.et-tabs-container, .tabs-left, .et-simple-slider, .et-image-slider');$et_shortcodes_tabs.each(function(i){var et_shortcodes_tab_class=$(this).attr('class'),et_shortcodes_tab_autospeed_class_value=/et_sliderauto_speed_(\d+)/g,et_shortcodes_tab_autospeed=et_shortcodes_tab_autospeed_class_value.exec(et_shortcodes_tab_class),et_shortcodes_tab_auto_class_value=/et_sliderauto_(\w+)/g,et_shortcodes_tab_auto=et_shortcodes_tab_auto_class_value.exec(et_shortcodes_tab_class),et_shortcodes_tab_type_class_value=/et_slidertype_(\w+)/g,et_shortcodes_tab_type=et_shortcodes_tab_type_class_value.exec(et_shortcodes_tab_class),et_shortcodes_tab_fx_class_value=/et_sliderfx_(\w+)/g,et_shortcodes_tab_fx=et_shortcodes_tab_fx_class_value.exec(et_shortcodes_tab_class),et_shortcodes_tab_apply_to_element='.et-tabs-content',et_shortcodes_tab_settings={};et_shortcodes_tab_settings.linksNav=$(this).find('.et-tabs-control li a');et_shortcodes_tab_settings.findParent=!0;et_shortcodes_tab_settings.fx=et_shortcodes_tab_fx[1];et_shortcodes_tab_settings.auto='false'===et_shortcodes_tab_auto[1]?!1:!0;et_shortcodes_tab_settings.autoSpeed=et_shortcodes_tab_autospeed[1];if('simple'===et_shortcodes_tab_type[1]){et_shortcodes_tab_settings={};et_shortcodes_tab_settings.fx=et_shortcodes_tab_fx[1];et_shortcodes_tab_settings.auto='false'===et_shortcodes_tab_auto[1]?!1:!0;et_shortcodes_tab_settings.autoSpeed=et_shortcodes_tab_autospeed[1];et_shortcodes_tab_settings.sliderType='simple';et_shortcodes_tab_apply_to_element='.et-simple-slides'}else if('images'===et_shortcodes_tab_type[1]){et_shortcodes_tab_settings.sliderType='images';et_shortcodes_tab_settings.linksNav='#'+$(this).attr('id')+' .controllers a.switch';et_shortcodes_tab_settings.findParent=!1;et_shortcodes_tab_settings.lengthElement='#'+$(this).attr('id')+' a.switch';et_shortcodes_tab_apply_to_element='.et-image-slides'}
$(this).find(et_shortcodes_tab_apply_to_element).et_shortcodes_switcher(et_shortcodes_tab_settings)})}})(jQuery);jQuery(function($){window.et_shortcodes_init()});
